/****************************************************************************************
- kinkonkankon.ino : Copyright (C) 2015 CoopTec(Katsuyoshi Takahama) All Rights Reserved.
- kinkonkankon.inoファイルの著作権は CoopTec(Katsuyoahi Takahama) が所有しています。
- CoopTec Web site : http://www.cooptec.jp/
-***************************************************************************************/
#include <Arduino.h>
#include "Melody.h"

// キンコーンカンコーン
uint16_t kinkonkankon_mm_crotchet = 60;
uint8_t  kinkonkankon_octave  = 5;
uint16_t kinkonkankon[] = {
 ONP_DO4 ,  ONP_MI4 ,  ONP_RE4 , ONP_SO2D, ONP_KU4 ,
 ONP_SO4D,  ONP_RE4 ,  ONP_MI4 , ONP_DO2 , ONP_KU4 ,
 ONP_MI4 ,  ONP_DO4 ,  ONP_RE4 , ONP_SO2D, ONP_KU4 ,
 ONP_SO4D,  ONP_RE4 ,  ONP_MI4 , ONP_DO2 , ONP_KU4 ,
 ONP_END
};

void setup()
{
  Melody.setPwmPin(6);  // PWM出力ピンセット
}

void loop() 
{
  Melody.setMM(MM_CROTCHET, kinkonkankon_mm_crotchet); // テンポ設定
  Melody.setOctave(kinkonkankon_octave);               // 音程設定
  Melody.play(kinkonkankon);                           // 演奏開始
}

