/*********************************************************************************
- Melody.h : Copyright (C) 2015 CoopTec(Katsuyoshi Takahama) All Rights Reserved.
- Melody.hファイルの著作権は CoopTec(Katsuyoahi Takahama) が所有しています。
- CoopTec Web site : http://www.cooptec.jp/
-*********************************************************************************/
#include <arduino.h>

class MelodyClass
{
private:
  uint8_t playmode;         
  uint8_t pwmpin;           
  HardwareSerial *MSerial;

  uint16_t WholeMM;      
  uint16_t HalfMM;       
  uint16_t CrotchetMM;  
  uint16_t EighthMM;     
  uint16_t SixteenthMM;  
  uint16_t WholeMS;      
  uint16_t HalfMS;       
  uint16_t CrotchetMS;   
  uint16_t EighthMS;     
  uint16_t SixteenthMS;	 
  uint16_t OnchoMS[5];   
  char*    OnchoStr[5];  
  
  char*    OnkaiStr[12]; 
  uint8_t  OctaveNo;	 

  void print(char *str);
  void println(char *str);
  void print(char one);
  int  getToneData(uint16_t data, uint16_t *onkai, uint16_t *onkai_t, uint16_t *oncho_ms, uint16_t *oncho_t, uint16_t *octave);
  void setToneData(uint16_t data, uint16_t *onkai, uint16_t *onkai_t, uint16_t *oncho_ms, uint16_t *oncho_t, uint16_t *octave);

public:
  MelodyClass();
  void setSerial(void *serial);
  void setPwmPin(uint8_t);	         
  int Command(int argc, char *argv[]);  
  int Help();                            
  void Tone(uint8_t u8Pin, unsigned int u16Frequency, unsigned long u32Duration);
  void melody(uint8_t no);
  void setMM(uint8_t mm_onpu, uint16_t mm);
  void setCrotchetMM(uint16_t mm);         
  void setOctave(uint8_t no);              
  void play(uint16_t *data);              
  void setPlayMode(uint8_t no);         
};
extern MelodyClass Melody;

#define MM_WHOLE     0
#define MM_HALF      1
#define MM_CROTCHET  2
#define MM_EIGHTH    3
#define MM_SIXTEENTH 4

#define PLAY_OUT_ENABLE   1
#define PLAY_OUT_DISABLE  0

#define ONP_END      0xFFFF

#define ONP_KU1      0
#define ONP_KU2	     1
#define ONP_KU4	     2
#define ONP_KU8	     3
#define ONP_KU16     4

#define ONP_DO1U   100
#define ONP_DO2U   101
#define ONP_DO4U   102
#define ONP_DO8U   103
#define ONP_DO16U  104
#define ONP_DO1    110
#define ONP_DO2	   111
#define ONP_DO4	   112
#define ONP_DO8	   113
#define ONP_DO16   114
#define ONP_DO1D   120
#define ONP_DO2D   122
#define ONP_DO4D   122
#define ONP_DO8D   123
#define ONP_DO16D  124

#define ONP_DOS1U  130
#define ONP_DOS2U  131
#define ONP_DOS4U  132
#define ONP_DOS8U  133
#define ONP_DOS16U 134
#define ONP_DOS1   140
#define ONP_DOS2   141
#define ONP_DOS4   142
#define ONP_DOS8   143
#define ONP_DOS16  144
#define ONP_DOS1D  150
#define ONP_DOS2D  151
#define ONP_DOS4D  152
#define ONP_DOS8D  153
#define ONP_DOS16D 154

#define ONP_RE1U   200
#define ONP_RE2U   201
#define ONP_RE4U   202
#define ONP_RE8U   203
#define ONP_RE16U  204
#define ONP_RE1	   210
#define ONP_RE2	   211
#define ONP_RE4	   212
#define ONP_RE8	   213
#define ONP_RE16   214
#define ONP_RE1D   220
#define ONP_RE2D   222
#define ONP_RE4D   222
#define ONP_RE8D   223
#define ONP_RE16D  224

#define ONP_RES1U  230
#define ONP_RES2U  231
#define ONP_RES4U  232
#define ONP_RES8U  233
#define ONP_RES16U 234
#define ONP_RES1   240
#define ONP_RES2   241
#define ONP_RES4   242
#define ONP_RES8   243
#define ONP_RES16  244
#define ONP_RES1D  250
#define ONP_RES2D  252
#define ONP_RES4D  252
#define ONP_RES8D  253
#define ONP_RES16D 254

#define ONP_MI1U   300
#define ONP_MI2U   301
#define ONP_MI4U   302
#define ONP_MI8U   303
#define ONP_MI16U  304
#define ONP_MI1    310
#define ONP_MI2	   311
#define ONP_MI4	   312
#define ONP_MI8	   313
#define ONP_MI16   314
#define ONP_MI1D   320
#define ONP_MI2D   322
#define ONP_MI4D   322
#define ONP_MI8D   323
#define ONP_MI16D  324

#define ONP_FA1U   400
#define ONP_FA2U   401
#define ONP_FA4U   402
#define ONP_FA8U   403
#define ONP_FA16U  404
#define ONP_FA1	   410
#define ONP_FA2	   411
#define ONP_FA4	   412
#define ONP_FA8	   413
#define ONP_FA16   414
#define ONP_FA1D   420
#define ONP_FA2D   422
#define ONP_FA4D   422
#define ONP_FA8D   423
#define ONP_FA16D  424

#define ONP_FAS1U  430
#define ONP_FAS2U  431
#define ONP_FAS4U  432
#define ONP_FAS8U  433
#define ONP_FAS16U 434
#define ONP_FAS1   440
#define ONP_FAS2   441
#define ONP_FAS4   442
#define ONP_FAS8   443
#define ONP_FAS16  444
#define ONP_FAS1D  450
#define ONP_FAS2D  452
#define ONP_FAS4D  452
#define ONP_FAS8D  453
#define ONP_FAS16D 454

#define ONP_SO1U   500
#define ONP_SO2U   501
#define ONP_SO4U   502
#define ONP_SO8U   503
#define ONP_SO16U  504
#define ONP_SO1	   510
#define ONP_SO2    511
#define ONP_SO4	   512
#define ONP_SO8	   513
#define ONP_SO16   514
#define ONP_SO1D   520
#define ONP_SO2D   522
#define ONP_SO4D   522
#define ONP_SO8D   523
#define ONP_SO16D  524

#define ONP_SOS1U  530
#define ONP_SOS2U  531
#define ONP_SOS4U  532
#define ONP_SOS8U  533
#define ONP_SOS16U 534
#define ONP_SOS1   540
#define ONP_SOS2   541
#define ONP_SOS4   542
#define ONP_SOS8   543
#define ONP_SOS16  544
#define ONP_SOS1D  550
#define ONP_SOS2D  552
#define ONP_SOS4D  552
#define ONP_SOS8D  553
#define ONP_SOS16D 554

#define ONP_RA1U   600
#define ONP_RA2U   601
#define ONP_RA4U   602
#define ONP_RA8U   603
#define ONP_RA16U  604
#define ONP_RA1	   610
#define ONP_RA2	   611
#define ONP_RA4	   612
#define ONP_RA8	   613
#define ONP_RA16   614
#define ONP_RA1D   620
#define ONP_RA2D   622
#define ONP_RA4D   622
#define ONP_RA8D   623
#define ONP_RA16D  624

#define ONP_RAS1U  630
#define ONP_RAS2U  631
#define ONP_RAS4U  632
#define ONP_RAS8U  633
#define ONP_RAS16U 634
#define ONP_RAS1   640
#define ONP_RAS2   641
#define ONP_RAS4   642
#define ONP_RAS8   643
#define ONP_RAS16  644
#define ONP_RAS1D  640
#define ONP_RAS2D  642
#define ONP_RAS4D  642
#define ONP_RAS8D  643
#define ONP_RAS16D 644

#define ONP_SI1U   700
#define ONP_SI2U   701
#define ONP_SI4U   702
#define ONP_SI8U   703
#define ONP_SI16U  704
#define ONP_SI1	   710
#define ONP_SI2	   711
#define ONP_SI4	   712
#define ONP_SI8	   713
#define ONP_SI16   714
#define ONP_SI1D   720
#define ONP_SI2D   722
#define ONP_SI4D   722
#define ONP_SI8D   723
#define ONP_SI16D  724



#define KU_ALL 1      // 無音


#define SI_0	31			// シ

#define DO_1	33			// ド
#define DO_1S	35			// ド＃
#define RE_1	37			// レ
#define RE_1S	39			// レ＃
#define MI_1	41			// ミ
#define FA_1	44			// ファ
#define FA_1S	46			// ファ＃
#define SO_1	49			// ソ
#define SO_1S	52			// ソ＃
#define RA_1	55			// ラ
#define RA_1S	58			// ラ＃
#define SI_1	62			// シ
#define DO_1	33			// ド
#define DO_1S	35			// ド＃
#define RE_1	37			// レ
#define RE_1S	39			// レ＃
#define MI_1	41			// ミ
#define FA_1	44			// ファ
#define FA_1S	46			// ファ＃
#define SO_1	49			// ソ
#define SO_1S	52			// ソ＃
#define RA_1	55			// ラ
#define RA_1S	58			// ラ＃
#define SI_1	62			// シ

#define DO_2	65			// ド
#define DO_2S	69			// ド＃
#define RE_2	73			// レ
#define RE_2S	78			// レ＃
#define MI_2	82			// ミ
#define FA_2	87			// ファ
#define FA_2S	93			// ファ＃
#define SO_2	98			// ソ
#define SO_2S	104			// ソ＃
#define RA_2	110			// ラ
#define RA_2S	117			// ラ＃
#define SI_2	123			// シ

#define DO_3	131			// ド
#define DO_3S	139			// ド＃
#define RE_3	147			// レ
#define RE_3S	156			// レ＃
#define MI_3	165			// ミ
#define FA_3	175			// ファ
#define FA_3S	185			// ファ＃
#define SO_3	196			// ソ
#define SO_3S	208			// ソ＃
#define RA_3	220			// ラ
#define RA_3S	233			// ラ＃
#define SI_3	247			// シ

#define DO_4	262			// ド				基準
#define DO_4S	277			// ド＃
#define RE_4	294			// レ
#define RE_4S	311			// レ＃
#define MI_4	330			// ミ
#define FA_4	349			// ファ
#define FA_4S	370			// ファ＃
#define SO_4	392			// ソ
#define SO_4S	415			// ソ＃
#define RA_4	440			// ラ
#define RA_4S	466			// ラ＃
#define SI_4	494			// シ

#define DO_5	523			// ド
#define DO_5S	554			// ド＃
#define RE_5	587			// レ
#define RE_5S	622			// レ＃
#define MI_5	659			// ミ
#define FA_5	698			// ファ
#define FA_5S	740			// ファ＃
#define SO_5	784			// ソ
#define SO_5S	831			// ソ＃
#define RA_5	880			// ラ
#define RA_5S	932			// ラ＃
#define SI_5	988			// シ

#define DO_6	1047			// ド
#define DO_6S	1109			// ド＃
#define RE_6	1175			// レ
#define RE_6S	1245			// レ＃
#define MI_6	1319			// ミ
#define FA_6	1397			// ファ
#define FA_6S	1480			// ファ＃
#define SO_6	1568			// ソ
#define SO_6S	1661			// ソ＃
#define RA_6	1760			// ラ
#define RA_6S	1865			// ラ＃
#define SI_6	1976			// シ

#define DO_7	2093			// ド
#define DO_7S	2217			// ド＃
#define RE_7	2349			// レ
#define RE_7S	2489			// レ＃
#define MI_7	2637			// ミ
#define FA_7	2794			// ファ
#define FA_7S	2960			// ファ＃
#define SO_7	3136			// ソ
#define SO_7S	3322			// ソ＃
#define RA_7	3520			// ラ
#define RA_7S	3729			// ラ＃
#define SI_7	3951			// シ

#define DO_8	4186			// ド
#define DO_8S	4435			// ド＃
#define RE_8	4699			// レ
#define RE_8S	4978			// レ＃
