/*********************************************************************************
- Melody.cpp : Copyright (C) 2015 CoopTec(Katsuyoshi Takahama) All Rights Reserved.
- Melody.cppファイルの著作権は CoopTec(Katsuyoahi Takahama) が所有しています。
- CoopTec Web site : http://www.cooptec.jp/
-*********************************************************************************/
#include "Melody.h"
MelodyClass Melody;
uint16_t ontei[9][12] = {
  {    0,     0,    0,     0,    0,    0,     0,    0,     0,    0,     0, SI_0 } ,
  { DO_1, DO_1S, RE_1, RE_1S, MI_1, FA_1, FA_1S, SO_1, SO_1S, RA_1, RA_1S, SI_1 } ,
  { DO_2, DO_2S, RE_2, RE_2S, MI_2, FA_2, FA_2S, SO_2, SO_2S, RA_2, RA_2S, SI_2 } ,
  { DO_3, DO_3S, RE_3, RE_3S, MI_3, FA_3, FA_3S, SO_3, SO_3S, RA_3, RA_3S, SI_3 } ,
  { DO_4, DO_4S, RE_4, RE_4S, MI_4, FA_4, FA_4S, SO_4, SO_4S, RA_4, RA_4S, SI_4 } ,   // ソ 440Hx
  { DO_5, DO_5S, RE_5, RE_5S, MI_5, FA_5, FA_5S, SO_5, SO_5S, RA_5, RA_5S, SI_5 } ,
  { DO_6, DO_6S, RE_6, RE_6S, MI_6, FA_6, FA_6S, SO_6, SO_6S, RA_6, RA_6S, SI_6 } ,
  { DO_7, DO_7S, RE_7, RE_7S, MI_7, FA_7, FA_7S, SO_7, SO_7S, RA_7, RA_7S, SI_7 } ,
  { DO_8, DO_8S, RE_8, RE_8S,    0,    0,     0,    0,     0,    0,     0,    0 }
};

void MelodyClass::play(uint16_t *data)
{
  char dd[80];
  uint16_t onkai;
  uint16_t onkai_t;
  uint16_t oncho_ms;
  uint16_t oncho_t;
  uint16_t octave;

  println((char *)"");
  println((char *)"       ONTEI   ONKAI(val)        ONCHO(ms)");
  for(uint16_t i=1;;i++) {
    if(*data == ONP_END) break;
    sprintf(dd, "%4d : ", i);
    print(dd);
    getToneData(*data, &onkai, &onkai_t, &oncho_ms, &oncho_t, &octave);
    if(onkai == KU_ALL) {
      sprintf(dd, "%3d   %7s(%5d)    %10s(%6d)", octave, "休", onkai, OnchoStr[oncho_t], oncho_ms);
    }
    else {
      sprintf(dd, "%3d   %8s(%5d)    %10s(%6d)", octave, OnkaiStr[onkai_t], onkai, OnchoStr[oncho_t], oncho_ms);
    }
    println(dd);
    Tone(pwmpin, onkai, oncho_ms);
    data++;
  }
}

void MelodyClass::setToneData(uint16_t data_t, uint16_t *onkai, uint16_t *onkai_t, uint16_t *oncho_ms, uint16_t *oncho_t, uint16_t *octave)
{
  if(data_t < 10)      {                                 (*octave)++; }
  else if(data_t < 20) { data_t=data_t-10;                            }
  else if(data_t < 30) { data_t=data_t-20;               (*octave)--; }
  else if(data_t < 40) { data_t=data_t-30; (*onkai_t)++; (*octave)++; }
  else if(data_t < 50) { data_t=data_t-40; (*onkai_t)++;              }
  else if(data_t < 60) { data_t=data_t-50; (*onkai_t)++; (*octave)--; }
  *onkai = ontei[*octave][*onkai_t];
  *oncho_ms = OnchoMS[data_t];
  *oncho_t = data_t;  
}

int MelodyClass::getToneData(uint16_t data, uint16_t *onkai, uint16_t *onkai_t, uint16_t *oncho_ms, uint16_t *oncho_t, uint16_t *octave)
{
  uint16_t data_t;
  
  *octave = OctaveNo;
  if(data < 100)   // 休止符
  {
    data_t = data;
    *onkai_t = data_t;
    *octave = OctaveNo;
    *onkai = KU_ALL;
    *oncho_ms = OnchoMS[data_t];
    *oncho_t = data_t;
    return 0;
  }
  else {
    if(data < 200) // ド
    {
      data_t = data - 100;
      *onkai_t = 0;
      *octave = OctaveNo;
    }
    else if(data < 300) // レ
    {
      data_t = data - 200;
      *onkai_t = 2;
      *octave = OctaveNo;
    }
    else if(data < 400) // ミ
    {
      data_t = data - 300;
      *onkai_t = 4;
      *octave = OctaveNo;
    }
    else if(data < 500) // ファ
    {
      data_t = data - 400;
      *onkai_t = 5;
      *octave = OctaveNo;
    }
    else if(data < 600) // ソ
    {
      data_t = data - 500;
      *onkai_t = 7;
      *octave = OctaveNo;
    }
    else if(data < 700) // ラ
    {
      data_t = data - 600;
      *onkai_t = 9;
      *octave = OctaveNo;
    }
    else if(data < 800) // シ
    {
      data_t = data - 700;
      *onkai_t = 11;
      *octave = OctaveNo;
    }
    setToneData(data_t, onkai, onkai_t, oncho_ms, oncho_t, octave);
  }
}

void MelodyClass::setMM(uint8_t mm_onpu, uint16_t mm)
{
  if(mm_onpu == MM_WHOLE) {
    WholeMM  = mm;
    HalfMM      = WholeMM * 2;
    CrotchetMM  = WholeMM * 4;
    EighthMM    = WholeMM * 8;
    SixteenthMM = WholeMM * 16;

    WholeMS  = 60000 / mm;
    HalfMS      = WholeMS / 2;
    CrotchetMS  = WholeMS / 4;
    EighthMS    = WholeMS / 8;
    SixteenthMS = WholeMS / 16;
  }
  else if(mm_onpu == MM_HALF) {
    HalfMM      = mm;
    WholeMM     = HalfMM / 2;
    CrotchetMM  = HalfMM * 2;
    EighthMM    = HalfMM * 4;
    SixteenthMM = HalfMM * 8;

    HalfMS      = 60000 / mm;
    WholeMS     = HalfMS * 2;
    CrotchetMS  = HalfMS / 2;
    EighthMS    = HalfMS / 4;
    SixteenthMS = HalfMS / 8;
  }
  else if(mm_onpu == MM_CROTCHET) {
    CrotchetMM  = mm;
    WholeMM     = CrotchetMM / 4;
    HalfMM      = CrotchetMM / 2;
    EighthMM    = CrotchetMM * 2;
    SixteenthMM = CrotchetMM * 4;

    CrotchetMS  = 60000 / mm;
    WholeMS     = CrotchetMS * 4;
    HalfMS      = CrotchetMS * 2;
    EighthMS    = CrotchetMS / 2;
    SixteenthMS = CrotchetMS / 4;
  }
  else if(mm_onpu == MM_EIGHTH) {
    EighthMM    = mm;
    WholeMM     = EighthMM / 8;
    HalfMM      = EighthMM / 4;
    CrotchetMM  = EighthMM / 2;
    SixteenthMM = EighthMM * 2;

    EighthMS    = 60000 / mm;
    WholeMS     = EighthMS * 8;
    HalfMS      = EighthMS * 4;
    CrotchetMS  = EighthMS * 2;
    SixteenthMS = EighthMS / 2;
  }
  else if(mm_onpu == MM_SIXTEENTH) {
    SixteenthMM  = mm;
    WholeMM     = SixteenthMM / 16;
    HalfMM      = SixteenthMM / 8;
    CrotchetMM  = SixteenthMM / 4;
    EighthMM    = SixteenthMM / 2;

    SixteenthMS = 60000 / mm;
    WholeMS     = SixteenthMS * 16;
    HalfMS      = SixteenthMS * 8;
    CrotchetMS  = SixteenthMS * 4;
    EighthMS    = SixteenthMS * 2;
  }

  OnchoMS[0] = WholeMS;
  OnchoMS[1] = HalfMS;
  OnchoMS[2] = CrotchetMS;
  OnchoMS[3] = EighthMS;
  OnchoMS[4] = SixteenthMS;
}

void MelodyClass::setCrotchetMM(uint16_t mm)
{
  CrotchetMM  = mm;
  WholeMM     = CrotchetMM / 4;
  HalfMM      = CrotchetMM / 2;
  EighthMM    = CrotchetMM * 2;
  SixteenthMM = CrotchetMM * 4;

  CrotchetMS  = 60000 / mm;
  WholeMS     = CrotchetMS * 4;
  HalfMS      = CrotchetMS * 2;
  EighthMS    = CrotchetMS / 2;
  SixteenthMS = CrotchetMS / 4;

  OnchoMS[0] = WholeMS;
  OnchoMS[1] = HalfMS;
  OnchoMS[2] = CrotchetMS;
  OnchoMS[3] = EighthMS;
  OnchoMS[4] = SixteenthMS;
}

void MelodyClass::setOctave(uint8_t no)
{
  OctaveNo = no;
}

void MelodyClass::setSerial(void *serial)
{
  MSerial = (HardwareSerial *)serial;
}

int MelodyClass::Help()
{
  println((char *)" = MELODY操作 ===================================================");// 
  println((char *)" m1 : ド1ド2ド3ド4ド5ド6ド7ド8");   //
  println((char *)" m2 : ドレミファソラシド");   //
}

int MelodyClass::Command(int argc, char *argv[])
{
  int ret;
  char tmp[50];
  switch(argc) {
  case 1:
    if(strcmp((char *)"m1",argv[0]) == 0) {
      melody(1);
      ret = 1;
    }
    else if(strcmp((char *)"m2",argv[0]) == 0) {
      melody(2);
      ret = 1;
    }
    else {
      return 0;
    }
    break;
  default:
    return 0;
  }
  return 1;
}

MelodyClass::MelodyClass()
{
  MSerial = 0;

  playmode = PLAY_OUT_ENABLE;
  OctaveNo = 4;
  setCrotchetMM(60);
  
  OnchoStr[0] = (char *)"　　全音符";
  OnchoStr[1] = (char *)"　２分音符";
  OnchoStr[2] = (char *)"　４分音符";
  OnchoStr[3] = (char *)"　８分音符";
  OnchoStr[4] = (char *)"１６分音符";

  OnkaiStr[0] =  (char *)"　ド　";
  OnkaiStr[1] =  (char *)"　ド＃";
  OnkaiStr[2] =  (char *)"　レ　";
  OnkaiStr[3] =  (char *)"　レ＃";
  OnkaiStr[4] =  (char *)"　ミ　";
  OnkaiStr[5] =  (char *)"ファ　";
  OnkaiStr[6] =  (char *)"ファ＃";
  OnkaiStr[7] =  (char *)"　ソ　";
  OnkaiStr[8] =  (char *)"　ソ＃";
  OnkaiStr[9] =  (char *)"　ラ　";
  OnkaiStr[10] = (char *)"　ラ＃";
  OnkaiStr[11] = (char *)"　シ　";
}

void MelodyClass::setPwmPin(uint8_t pwmpinin)
{
  pwmpin = pwmpinin;
}

void MelodyClass::setPlayMode(uint8_t mode)
{
  playmode = mode;
}

void MelodyClass::Tone(uint8_t u8Pin, unsigned int u16Frequency, unsigned long u32Duration)
{
  if(playmode) tone(u8Pin, u16Frequency, u32Duration);
  delay(u32Duration);
  noTone(pwmpin);
}

void MelodyClass::melody(uint8_t no)
{
  if(no == 1) {
    Tone(pwmpin, DO_1S, 1000);
    Tone(pwmpin, DO_2S, 1000);
    Tone(pwmpin, DO_3S, 1000);
    Tone(pwmpin, DO_4S, 1000);
    Tone(pwmpin, DO_5S, 1000);
    Tone(pwmpin, DO_6S, 1000);
    Tone(pwmpin, DO_7S, 1000);
    Tone(pwmpin, DO_8S, 1000);
  }
  else if(no == 2) {
    Tone(pwmpin, DO_5, 600);
    Tone(pwmpin, RE_5, 600);
    Tone(pwmpin, MI_5, 600);
    Tone(pwmpin, FA_5, 600);
    Tone(pwmpin, SO_5, 600);
    Tone(pwmpin, RA_5, 600);
    Tone(pwmpin, SI_5, 600);
    Tone(pwmpin, DO_6, 600);
  }
}

void MelodyClass::print(char one)
{
  if(MSerial) MSerial->print(one);
}
void MelodyClass::print(char *str)
{
  if(MSerial) MSerial->print(str);
}
void MelodyClass::println(char *str)
{
  if(MSerial) MSerial->print(str);
  if(MSerial) MSerial->print("\r\n");
}


